#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <set>
using namespace std;
vector<int> Q; 
vector<pair<int, int>> grane;
double epsilon;
double Menhetn(vector<double> x, vector<double> y, int i, int j)
{
    return abs(x[i] - x[j]) + abs(y[i] - y[j]);
}
void dfs(vector<double> x, vector<double> y,int u, int glavnaTacka, vector<vector<int>> deca)
{
    for (auto const& v : deca[u])
    {
        if (Menhetn(x,y,v, glavnaTacka) <= epsilon)
        {
            dfs(x,y,v, glavnaTacka,deca);
        }
        else
        {
            Q.push_back(v);                     
            grane.push_back({glavnaTacka, v});
            dfs(x,y,v, v,deca);                          
        }
    }
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >> n >> epsilon;
    vector<double> x(n), y(n);
    vector<double> minMenhetn(n);
    vector<int> roditelj(n);
    vector<bool> posecen(n,false);
    vector<vector<int>> deca(n);
    for (int i = 0; i < n; i++)
    {
        cin >> x[i] >> y[i];
        minMenhetn[i] = 2;
    }
    minMenhetn[0] = 0;
    roditelj[0] = -1;
    set<pair<double, int>> par;
    par.insert({ 0,0 });
    while (!par.empty()) 
    {
        pair<double, int> p = *par.begin();
        par.erase(par.begin());
        int u = p.second;
        if (posecen[u]) continue;
        posecen[u] = true;
        if (roditelj[u] != -1)
        {
            deca[roditelj[u]].push_back(u);
        }
        for (int v = 0; v < n; v++)
        {
            if (!posecen[v])
            {
                double d = Menhetn(x, y, u, v);
                if (d < minMenhetn[v])
                {
                    if (minMenhetn[v] != 2.0) 
                    {
                        par.erase({ minMenhetn[v], v });
                    }
                    minMenhetn[v] = d;
                    roditelj[v] = u;
                    par.insert({ minMenhetn[v], v });
                }
            }
        }
    }
    Q.push_back(0);
    dfs(x, y, 0, 0, deca);
    cout << Q.size() << "\n";
    for (long long i = 0; i < Q.size(); i++)
    {
        cout << (Q[i] + 1) << (i == Q.size() - 1 ? "" : " ");
    }
    cout << "\n";
    for (auto const& grana : grane)
    {
        cout << (grana.first + 1) << " " << (grana.second + 1) << "\n";
    }
    return 0;
}